/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.basicplayer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.jlgui.basicplayer.BasicController;
import javazoom.jlgui.basicplayer.BasicPlayerEventLauncher;
import javazoom.jlgui.basicplayer.BasicPlayerException;
import javazoom.jlgui.basicplayer.BasicPlayerListener;
import javazoom.spi.PropertiesContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tritonus.share.sampled.TAudioFormat;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class BasicPlayer
implements BasicController,
Runnable {
    public static int EXTERNAL_BUFFER_SIZE = 16000;
    public static int SKIP_INACCURACY_SIZE = 1200;
    protected Thread m_thread = null;
    protected Object m_dataSource = null;
    protected AudioInputStream m_encodedaudioInputStream;
    protected int encodedLength = -1;
    protected AudioInputStream m_audioInputStream;
    protected AudioFileFormat m_audioFileFormat;
    protected SourceDataLine m_line;
    protected FloatControl m_gainControl;
    protected FloatControl m_panControl;
    protected String m_mixerName = null;
    private int m_lineCurrentBufferSize = -1;
    private int lineBufferSize = -1;
    private long threadSleep = -1L;
    private static Logger log = LoggerFactory.getLogger(BasicPlayer.class);
    public static final int UNKNOWN = -1;
    public static final int PLAYING = 0;
    public static final int PAUSED = 1;
    public static final int STOPPED = 2;
    public static final int OPENED = 3;
    public static final int SEEKING = 4;
    private int m_status = -1;
    private Collection m_listeners = null;
    private Map empty_map = new HashMap();

    public BasicPlayer() {
        this.m_listeners = new ArrayList();
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        this.m_status = -1;
        if (this.m_audioInputStream != null) {
            AudioInputStream audioInputStream = this.m_audioInputStream;
            synchronized (audioInputStream) {
                this.closeStream();
            }
        }
        this.m_audioInputStream = null;
        this.m_audioFileFormat = null;
        this.m_encodedaudioInputStream = null;
        this.encodedLength = -1;
        if (this.m_line != null) {
            this.m_line.stop();
            this.m_line.close();
            this.m_line = null;
        }
        this.m_gainControl = null;
        this.m_panControl = null;
    }

    public void addBasicPlayerListener(BasicPlayerListener bpl) {
        this.m_listeners.add(bpl);
    }

    public Collection getListeners() {
        return this.m_listeners;
    }

    public void removeBasicPlayerListener(BasicPlayerListener bpl) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(bpl);
        }
    }

    public void setLineBufferSize(int size) {
        this.lineBufferSize = size;
    }

    public int getLineBufferSize() {
        return this.lineBufferSize;
    }

    public int getLineCurrentBufferSize() {
        return this.m_lineCurrentBufferSize;
    }

    public void setSleepTime(long time) {
        this.threadSleep = time;
    }

    public long getSleepTime() {
        return this.threadSleep;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void open(File file) throws BasicPlayerException {
        log.info("open(" + file + ")");
        if (file != null) {
            this.m_dataSource = file;
            this.initAudioInputStream();
        }
    }

    public void open(URL url) throws BasicPlayerException {
        log.info("open(" + url + ")");
        if (url != null) {
            this.m_dataSource = url;
            this.initAudioInputStream();
        }
    }

    public void open(InputStream inputStream) throws BasicPlayerException {
        log.info("open(" + inputStream + ")");
        if (inputStream != null) {
            this.m_dataSource = inputStream;
            this.initAudioInputStream();
        }
    }

    protected void initAudioInputStream() throws BasicPlayerException {
        try {
            AudioFormat audioFormat;
            this.reset();
            this.notifyEvent(0, this.getEncodedStreamPosition(), -1.0, this.m_dataSource);
            if (this.m_dataSource instanceof URL) {
                this.initAudioInputStream((URL)this.m_dataSource);
            } else if (this.m_dataSource instanceof File) {
                this.initAudioInputStream((File)this.m_dataSource);
            } else if (this.m_dataSource instanceof InputStream) {
                this.initAudioInputStream((InputStream)this.m_dataSource);
            }
            this.createLine();
            Map<String, String> properties = null;
            if (this.m_audioFileFormat instanceof TAudioFileFormat) {
                properties = ((TAudioFileFormat)this.m_audioFileFormat).properties();
                properties = this.deepCopy(properties);
            } else {
                properties = new HashMap();
            }
            if (this.m_audioFileFormat.getByteLength() > 0) {
                properties.put("audio.length.bytes", (String)((Object)new Integer(this.m_audioFileFormat.getByteLength())));
            }
            if (this.m_audioFileFormat.getFrameLength() > 0) {
                properties.put("audio.length.frames", (String)((Object)new Integer(this.m_audioFileFormat.getFrameLength())));
            }
            if (this.m_audioFileFormat.getType() != null) {
                properties.put("audio.type", this.m_audioFileFormat.getType().toString());
            }
            if ((audioFormat = this.m_audioFileFormat.getFormat()).getFrameRate() > 0.0f) {
                properties.put("audio.framerate.fps", (String)((Object)new Float(audioFormat.getFrameRate())));
            }
            if (audioFormat.getFrameSize() > 0) {
                properties.put("audio.framesize.bytes", (String)((Object)new Integer(audioFormat.getFrameSize())));
            }
            if (audioFormat.getSampleRate() > 0.0f) {
                properties.put("audio.samplerate.hz", (String)((Object)new Float(audioFormat.getSampleRate())));
            }
            if (audioFormat.getSampleSizeInBits() > 0) {
                properties.put("audio.samplesize.bits", (String)((Object)new Integer(audioFormat.getSampleSizeInBits())));
            }
            if (audioFormat.getChannels() > 0) {
                properties.put("audio.channels", (String)((Object)new Integer(audioFormat.getChannels())));
            }
            if (audioFormat instanceof TAudioFormat) {
                Map addproperties = ((TAudioFormat)audioFormat).properties();
                properties.putAll(addproperties);
            }
            properties.put("basicplayer.sourcedataline", (String)((Object)this.m_line));
            for (BasicPlayerListener bpl : this.m_listeners) {
                bpl.opened(this.m_dataSource, properties);
            }
            this.m_status = 3;
            this.notifyEvent(1, this.getEncodedStreamPosition(), -1.0, null);
        }
        catch (LineUnavailableException e) {
            throw new BasicPlayerException(e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new BasicPlayerException(e);
        }
        catch (IOException e) {
            throw new BasicPlayerException(e);
        }
    }

    protected void initAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        this.m_audioInputStream = AudioSystem.getAudioInputStream(file);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(file);
    }

    protected void initAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        this.m_audioInputStream = AudioSystem.getAudioInputStream(url);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(url);
    }

    protected void initAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        this.m_audioInputStream = AudioSystem.getAudioInputStream(inputStream);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(inputStream);
    }

    protected void initLine() throws LineUnavailableException {
        log.info("initLine()");
        if (this.m_line == null) {
            this.createLine();
        }
        if (!this.m_line.isOpen()) {
            this.openLine();
        } else {
            AudioFormat audioInputStreamFormat;
            AudioFormat lineAudioFormat = this.m_line.getFormat();
            AudioFormat audioFormat = audioInputStreamFormat = this.m_audioInputStream == null ? null : this.m_audioInputStream.getFormat();
            if (!lineAudioFormat.equals(audioInputStreamFormat)) {
                this.m_line.close();
                this.openLine();
            }
        }
    }

    protected void createLine() throws LineUnavailableException {
        log.info("Create Line");
        if (this.m_line == null) {
            AudioFormat sourceFormat = this.m_audioInputStream.getFormat();
            log.info("Create Line : Source format : " + sourceFormat.toString());
            int nSampleSizeInBits = sourceFormat.getSampleSizeInBits();
            if (nSampleSizeInBits <= 0) {
                nSampleSizeInBits = 16;
            }
            if (sourceFormat.getEncoding() == AudioFormat.Encoding.ULAW || sourceFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
                nSampleSizeInBits = 16;
            }
            if (nSampleSizeInBits != 8) {
                nSampleSizeInBits = 16;
            }
            AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), nSampleSizeInBits, sourceFormat.getChannels(), sourceFormat.getChannels() * (nSampleSizeInBits / 8), sourceFormat.getSampleRate(), false);
            log.info("Create Line : Target format: " + targetFormat);
            this.m_encodedaudioInputStream = this.m_audioInputStream;
            try {
                this.encodedLength = this.m_encodedaudioInputStream.available();
            }
            catch (IOException e) {
                log.error("Cannot get m_encodedaudioInputStream.available()", (Throwable)e);
            }
            this.m_audioInputStream = AudioSystem.getAudioInputStream(targetFormat, this.m_audioInputStream);
            AudioFormat audioFormat = this.m_audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
            Mixer mixer = this.getMixer(this.m_mixerName);
            if (mixer != null) {
                log.info("Mixer : " + mixer.getMixerInfo().toString());
                this.m_line = (SourceDataLine)mixer.getLine(info);
            } else {
                this.m_line = (SourceDataLine)AudioSystem.getLine(info);
                this.m_mixerName = null;
            }
            log.info("Line : " + this.m_line.toString());
            log.debug("Line Info : " + this.m_line.getLineInfo().toString());
            log.debug("Line AudioFormat: " + this.m_line.getFormat().toString());
        }
    }

    protected void openLine() throws LineUnavailableException {
        if (this.m_line != null) {
            AudioFormat audioFormat = this.m_audioInputStream.getFormat();
            int buffersize = this.lineBufferSize;
            if (buffersize <= 0) {
                buffersize = this.m_line.getBufferSize();
            }
            this.m_lineCurrentBufferSize = buffersize;
            this.m_line.open(audioFormat, buffersize);
            log.info("Open Line : BufferSize=" + buffersize);
            Control[] c = this.m_line.getControls();
            for (int p = 0; p < c.length; ++p) {
                log.debug("Controls : " + c[p].toString());
            }
            if (this.m_line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                this.m_gainControl = (FloatControl)this.m_line.getControl(FloatControl.Type.MASTER_GAIN);
                log.info("Master Gain Control : [" + this.m_gainControl.getMinimum() + "," + this.m_gainControl.getMaximum() + "] " + this.m_gainControl.getPrecision());
            }
            if (this.m_line.isControlSupported(FloatControl.Type.PAN)) {
                this.m_panControl = (FloatControl)this.m_line.getControl(FloatControl.Type.PAN);
                log.info("Pan Control : [" + this.m_panControl.getMinimum() + "," + this.m_panControl.getMaximum() + "] " + this.m_panControl.getPrecision());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopPlayback() {
        if (this.m_status == 0 || this.m_status == 1) {
            if (this.m_line != null) {
                this.m_line.flush();
                this.m_line.stop();
            }
            this.m_status = 2;
            this.notifyEvent(3, this.getEncodedStreamPosition(), -1.0, null);
            AudioInputStream audioInputStream = this.m_audioInputStream;
            synchronized (audioInputStream) {
                this.closeStream();
            }
            log.info("stopPlayback() completed");
        }
    }

    protected void pausePlayback() {
        if (this.m_line != null && this.m_status == 0) {
            this.m_line.flush();
            this.m_line.stop();
            this.m_status = 1;
            log.info("pausePlayback() completed");
            this.notifyEvent(4, this.getEncodedStreamPosition(), -1.0, null);
        }
    }

    protected void resumePlayback() {
        if (this.m_line != null && this.m_status == 1) {
            this.m_line.start();
            this.m_status = 0;
            log.info("resumePlayback() completed");
            this.notifyEvent(5, this.getEncodedStreamPosition(), -1.0, null);
        }
    }

    protected void startPlayback() throws BasicPlayerException {
        if (this.m_status == 2) {
            this.initAudioInputStream();
        }
        if (this.m_status == 3) {
            log.info("startPlayback called");
            if (this.m_thread != null && this.m_thread.isAlive()) {
                log.info("WARNING: old thread still running!!");
                int cnt = 0;
                while (this.m_status != 3) {
                    try {
                        if (this.m_thread == null) continue;
                        log.info("Waiting ... " + cnt);
                        Thread.sleep(1000L);
                        if (++cnt <= 2) continue;
                        this.m_thread.interrupt();
                    }
                    catch (InterruptedException e) {
                        throw new BasicPlayerException("Wait error", e);
                    }
                }
            }
            try {
                this.initLine();
            }
            catch (LineUnavailableException e) {
                throw new BasicPlayerException("Cannot init line", e);
            }
            log.info("Creating new thread");
            this.m_thread = new Thread((Runnable)this, "BasicPlayer");
            this.m_thread.start();
            if (this.m_line != null) {
                this.m_line.start();
                this.m_status = 0;
                this.notifyEvent(2, this.getEncodedStreamPosition(), -1.0, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.info("Thread Running");
        int nBytesRead = 1;
        byte[] abData = new byte[EXTERNAL_BUFFER_SIZE];
        AudioInputStream audioInputStream = this.m_audioInputStream;
        synchronized (audioInputStream) {
            while (nBytesRead != -1 && this.m_status != 2 && this.m_status != 4 && this.m_status != -1) {
                if (this.m_status == 0) {
                    try {
                        nBytesRead = this.m_audioInputStream.read(abData, 0, abData.length);
                        if (nBytesRead >= 0) {
                            byte[] pcm = new byte[nBytesRead];
                            System.arraycopy(abData, 0, pcm, 0, nBytesRead);
                            if (this.m_line.available() >= this.m_line.getBufferSize()) {
                                log.debug("Underrun : " + this.m_line.available() + "/" + this.m_line.getBufferSize());
                            }
                            int nBytesWritten = this.m_line.write(abData, 0, nBytesRead);
                            int nEncodedBytes = this.getEncodedStreamPosition();
                            for (BasicPlayerListener bpl : this.m_listeners) {
                                if (this.m_audioInputStream instanceof PropertiesContainer) {
                                    Map properties = ((PropertiesContainer)this.m_audioInputStream).properties();
                                    bpl.progress(nEncodedBytes, this.m_line.getMicrosecondPosition(), pcm, properties);
                                    continue;
                                }
                                bpl.progress(nEncodedBytes, this.m_line.getMicrosecondPosition(), pcm, this.empty_map);
                            }
                        }
                    }
                    catch (IOException e) {
                        log.error("Thread cannot run()", (Throwable)e);
                        this.m_status = 2;
                        this.notifyEvent(3, this.getEncodedStreamPosition(), -1.0, null);
                    }
                    if (this.threadSleep <= 0L) continue;
                    try {
                        Thread.sleep(this.threadSleep);
                    }
                    catch (InterruptedException e) {
                        log.error("Thread cannot sleep(" + this.threadSleep + ")", (Throwable)e);
                    }
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error("Thread cannot sleep(1000)", (Throwable)e);
                }
            }
            if (this.m_line != null) {
                this.m_line.drain();
                this.m_line.stop();
                this.m_line.close();
                this.m_line = null;
            }
            if (nBytesRead == -1) {
                this.notifyEvent(8, this.getEncodedStreamPosition(), -1.0, null);
            }
            this.closeStream();
        }
        this.m_status = 2;
        this.notifyEvent(3, this.getEncodedStreamPosition(), -1.0, null);
        log.info("Thread completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long skipBytes(long bytes) throws BasicPlayerException {
        long totalSkipped = 0L;
        if (this.m_dataSource instanceof File) {
            log.info("Bytes to skip : " + bytes);
            int previousStatus = this.m_status;
            this.m_status = 4;
            long skipped = 0L;
            try {
                AudioInputStream audioInputStream = this.m_audioInputStream;
                synchronized (audioInputStream) {
                    this.notifyEvent(6, this.getEncodedStreamPosition(), -1.0, null);
                    this.initAudioInputStream();
                    if (this.m_audioInputStream != null) {
                        while (totalSkipped < bytes - (long)SKIP_INACCURACY_SIZE && (skipped = this.m_audioInputStream.skip(bytes - totalSkipped)) != 0L) {
                            log.info("Skipped : " + (totalSkipped += skipped) + "/" + bytes);
                            if (totalSkipped != -1L) continue;
                            throw new BasicPlayerException("Skip not supported");
                        }
                    }
                }
                this.notifyEvent(7, this.getEncodedStreamPosition(), -1.0, null);
                this.m_status = 3;
                if (previousStatus == 0) {
                    this.startPlayback();
                } else if (previousStatus == 1) {
                    this.startPlayback();
                    this.pausePlayback();
                }
            }
            catch (IOException e) {
                throw new BasicPlayerException(e);
            }
        }
        return totalSkipped;
    }

    protected void notifyEvent(int code, int position, double value, Object description) {
        BasicPlayerEventLauncher trigger = new BasicPlayerEventLauncher(code, position, value, description, new ArrayList(this.m_listeners), this);
        trigger.start();
    }

    protected int getEncodedStreamPosition() {
        int nEncodedBytes = -1;
        if (this.m_dataSource instanceof File) {
            try {
                if (this.m_encodedaudioInputStream != null) {
                    nEncodedBytes = this.encodedLength - this.m_encodedaudioInputStream.available();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return nEncodedBytes;
    }

    protected void closeStream() {
        try {
            if (this.m_audioInputStream != null) {
                this.m_audioInputStream.close();
                log.info("Stream closed");
            }
        }
        catch (IOException e) {
            log.info("Cannot close stream", (Throwable)e);
        }
    }

    public boolean hasGainControl() {
        if (this.m_gainControl == null && this.m_line != null && this.m_line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.m_gainControl = (FloatControl)this.m_line.getControl(FloatControl.Type.MASTER_GAIN);
        }
        return this.m_gainControl != null;
    }

    public float getGainValue() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getValue();
        }
        return 0.0f;
    }

    public float getMaximumGain() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getMaximum();
        }
        return 0.0f;
    }

    public float getMinimumGain() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getMinimum();
        }
        return 0.0f;
    }

    public boolean hasPanControl() {
        if (this.m_panControl == null && this.m_line != null && this.m_line.isControlSupported(FloatControl.Type.PAN)) {
            this.m_panControl = (FloatControl)this.m_line.getControl(FloatControl.Type.PAN);
        }
        return this.m_panControl != null;
    }

    public float getPrecision() {
        if (this.hasPanControl()) {
            return this.m_panControl.getPrecision();
        }
        return 0.0f;
    }

    public float getPan() {
        if (this.hasPanControl()) {
            return this.m_panControl.getValue();
        }
        return 0.0f;
    }

    protected Map deepCopy(Map src) {
        HashMap map = new HashMap();
        if (src != null) {
            for (Object key : src.keySet()) {
                Object value = src.get(key);
                map.put(key, value);
            }
        }
        return map;
    }

    public long seek(long bytes) throws BasicPlayerException {
        return this.skipBytes(bytes);
    }

    public void play() throws BasicPlayerException {
        this.startPlayback();
    }

    public void stop() throws BasicPlayerException {
        this.stopPlayback();
    }

    public void pause() throws BasicPlayerException {
        this.pausePlayback();
    }

    public void resume() throws BasicPlayerException {
        this.resumePlayback();
    }

    public void setPan(double fPan) throws BasicPlayerException {
        if (!this.hasPanControl()) {
            throw new BasicPlayerException("Pan control not supported");
        }
        log.debug("Pan : " + fPan);
        this.m_panControl.setValue((float)fPan);
        this.notifyEvent(9, this.getEncodedStreamPosition(), fPan, null);
    }

    public void setGain(double fGain) throws BasicPlayerException {
        if (!this.hasGainControl()) {
            throw new BasicPlayerException("Gain control not supported");
        }
        double minGainDB = this.getMinimumGain();
        double ampGainDB = 0.5f * this.getMaximumGain() - this.getMinimumGain();
        double cste = Math.log(10.0) / 20.0;
        double valueDB = minGainDB + 1.0 / cste * Math.log(1.0 + (Math.exp(cste * ampGainDB) - 1.0) * fGain);
        log.debug("Gain : " + valueDB);
        this.m_gainControl.setValue((float)valueDB);
        this.notifyEvent(10, this.getEncodedStreamPosition(), fGain, null);
    }

    public List getMixers() {
        ArrayList<String> mixers = new ArrayList<String>();
        Mixer.Info[] mInfos = AudioSystem.getMixerInfo();
        if (mInfos != null) {
            for (int i = 0; i < mInfos.length; ++i) {
                Line.Info lineInfo = new Line.Info(SourceDataLine.class);
                Mixer mixer = AudioSystem.getMixer(mInfos[i]);
                if (!mixer.isLineSupported(lineInfo)) continue;
                mixers.add(mInfos[i].getName());
            }
        }
        return mixers;
    }

    public Mixer getMixer(String name) {
        Mixer.Info[] mInfos;
        Mixer mixer = null;
        if (name != null && (mInfos = AudioSystem.getMixerInfo()) != null) {
            for (int i = 0; i < mInfos.length; ++i) {
                if (!mInfos[i].getName().equals(name)) continue;
                mixer = AudioSystem.getMixer(mInfos[i]);
                break;
            }
        }
        return mixer;
    }

    public String getMixerName() {
        return this.m_mixerName;
    }

    public void setMixerName(String name) {
        this.m_mixerName = name;
    }
}

